<?php
ini_set('display_errors', 1);
if(session_status() === PHP_SESSION_NONE) session_start();
include(__DIR__ . '/functions.php');

$log_check = $db->select('users', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;
if (empty($loggedinuser) && isset($_SESSION['name']) && $_SESSION['name'] === $loggedinuser) {
	header("Location: index.php");
	exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="Bet3">
    <title>Rgvip 4K Plus Panel</title>
    
    <!-- Favicon -->
    <link rel="icon" href="img/logo.png" type="image/png">
    
    <!-- CSS Libraries -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
    <link href="css/themes/darkly/bootstrap.css" rel="stylesheet" title="main">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.2.3/animate.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link href="css/simple-sidebar.css" rel="stylesheet">
    
    <style>
        :root {
            --neon-purple: #0ff;
            --neon-blue: #0ff0fc;
            --neon-pink: #ff44cc;
            --neon-green: #00ff41;
            --dark-bg: #0a0a1a;
            --darker-bg: #050510;
            --sidebar-width: 250px;
            --glow-intensity: 0.8;
        }
        
        body {
            background-color: var(--dark-bg);
            background-image: linear-gradient(to bottom, rgba(11, 5, 26, 0.9), rgba(5, 5, 16, 1)), url("./img/binding_dark.webp");
            color: #fff;
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        /* Neon Glow Effects */
        .neon-purple {
            text-shadow: 0 0 0.5px #fff, 0 0 1px #fff, 0 0 10px var(--neon-purple), 0 0 15px var(--neon-purple);
        }
        
        .neon-blue {
            text-shadow: 0 0 5px #fff, 0 0 10px #fff, 0 0 15px var(--neon-blue), 0 0 20px var(--neon-blue);
        }
        
        /* Particles Background */
        #js-particles {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            opacity: 0.6;
        }
        
        /* Sidebar Neon Style */
        #sidebar-wrapper {
            background: linear-gradient(to right, var(--darker-bg), rgba(15, 5, 30, 0.9));
            border-right: 1px solid rgba(188, 19, 254, 0.2);
            box-shadow: 0 0 20px rgba(188, 19, 254, 0.3);
        }
        
        .sidebar-heading {
            padding: 1.5rem 1.25rem;
            font-size: 1.4rem;
            font-weight: bold;
            text-align: center;
            border-bottom: 1px solid rgba(188, 19, 254, 0.3);
            color: var(--neon-purple);
            letter-spacing: 1px;
            background: linear-gradient(to right, transparent, rgba(188, 19, 254, 0.1), transparent);
        }
        
        .list-group-item {
            background-color: transparent;
            border-color: rgba(188, 19, 254, 0.2);
            color: #e0e0e0;
            transition: all 0.3s ease;
            margin: 5px 10px;
            border-radius: 4px;
        }
        
        .list-group-item:hover {
            background-color: rgba(188, 19, 254, 0.15);
            padding-left: 1.5rem;
            color: white;
            box-shadow: 0 0 10px rgba(188, 19, 254, 0.5);
            border-left: 3px solid var(--neon-purple);
        }
        
        .list-group-item i {
            width: 20px;
            text-align: center;
            color: var(--neon-blue);
        }
        
        /* Navbar Neon Style */
        .navbar {
            background: linear-gradient(to right, rgba(5, 5, 16, 0.9), rgba(15, 5, 30, 0.9)) !important;
            backdrop-filter: blur(8px);
            padding: 0.7rem 1.2rem;
            border-bottom: 1px solid rgba(188, 19, 254, 0.3);
            box-shadow: 0 2px 20px rgba(0, 255, 65, 0.1);
        }
        
        #menu-toggle {
            background: rgba(188, 19, 254, 0.2);
            border: 1px solid var(--neon-purple);
            color: white;
            transition: all 0.3s ease;
            box-shadow: 0 0 10px rgba(188, 19, 254, 0.3);
        }
        
        #menu-toggle:hover {
            transform: rotate(90deg);
            background: rgba(188, 19, 254, 0.4);
            box-shadow: 0 0 20px rgba(188, 19, 254, 0.6);
        }
        
        /* Buttons Neon Style */
        .btn-danger {
            background: rgba(255, 0, 85, 0.2);
            border: 1px solid #ff0055;
            color: #ff99c2;
            transition: all 0.3s ease;
        }
        
        .btn-danger:hover {
            background: rgba(255, 0, 85, 0.4);
            color: white;
            box-shadow: 0 0 15px rgba(255, 0, 85, 0.6);
            text-shadow: 0 0 5px #ff99c2;
        }
        
        /* Messages */
        #pageMessages {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            text-align: center;
            top: 15px;
            width: 60%;
            z-index: 9999;
            border-radius: 4px;
        }
        
        .alert {
            position: relative;
            box-shadow: 0 0 15px rgba(0, 255, 65, 0.3);
            border: 1px solid rgba(0, 255, 65, 0.5);
            background: rgba(10, 20, 15, 0.9);
            backdrop-filter: blur(5px);
        }
        
        /* Copyright Footer */
        .copyright {
            font-size: 0.8rem;
            opacity: 0.7;
            padding: 1.5rem;
            text-align: center;
            border-top: 1px solid rgba(188, 19, 254, 0.3);
            color: var(--neon-blue);
        }
        
        .copyright a {
            color: var(--neon-blue);
            text-decoration: none;
            transition: all 0.3s ease;
        }
        
        .copyright a:hover {
            text-shadow: 0 0 5px var(--neon-blue);
            color: white;
        }
        
        /* Animation for neon elements */
        @keyframes neon-pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.7; }
        }
        
        .neon-pulse {
            animation: neon-pulse 2s infinite;
        }
        
        /* Main content area */
        .container-fluid {
            padding: 2rem;
        }
    </style>
</head>
<body>
    <!-- Particles Background -->
    <div id="js-particles"></div>
    
    <!-- Page Wrapper -->
    <div class="d-flex" id="wrapper">
        <!-- Sidebar -->
        <div class="" id="sidebar-wrapper">
            <div class="sidebar-heading neon-purple">
                <img src="img/logo.png" width="30" height="30" class="mr-2 neon-pulse" alt="Logo">
                Rgvip 4K Plus
            </div>
            
            <!-- Navigation Menu -->
<div class="list-group list-group-flush">
    <a class="list-group-item list-group-item-action" href="dns.php">
        <i class="fa fa-cogs"></i>&nbsp;&nbsp; Servidores DNS
    </a>
    <a class="list-group-item list-group-item-action" href="actusers.php">
        <i class="fa fa-users"></i>&nbsp;&nbsp; Clientes Mac
    </a>
    <a class="list-group-item list-group-item-action" href="generar_codes.php">
        <i class="fa fa-key"></i>&nbsp;&nbsp; Generar Códigos
    </a>
    <a class="list-group-item list-group-item-action" href="gestionar_codes.php">
        <i class="fa fa-list-alt"></i>&nbsp;&nbsp; Gestionar Códigos
    </a>
    <a class="list-group-item list-group-item-action" href="activar_codes.php">
        <i class="fa fa-check-circle"></i>&nbsp;&nbsp; Activar Códigos
    </a>
    <a class="list-group-item list-group-item-action" href="resellers_codes.php">
        <i class="fa fa-users"></i>&nbsp;&nbsp; Gestionar Resellers
    </a>
    <a class="list-group-item list-group-item-action" href="resellers_login.php">
        <i class="fa fa-link"></i>&nbsp;&nbsp; Link Resellers
    </a>
    <a class="list-group-item list-group-item-action" href="activar_public.php">
        <i class="fa fa-cog"></i>&nbsp;&nbsp; Link Clientes
    </a>
    <a class="list-group-item list-group-item-action" href="apk_manage.php">
        <i class="fa fa-android"></i>&nbsp;&nbsp; APP Update
    </a>
     <a class="list-group-item list-group-item-action" href="user.php">
        <i class="fa fa-user"></i>&nbsp;&nbsp; Perfil
    </a>
</div>
            
            <!-- Copyright Footer -->
            <div class="copyright">
                <a href="https://apps-rgvip.com" target="_blank">
                    <i class="fa fa-copyright"></i> <?=date("Y")?> Rgvip Panels
                </a>
            </div>
        </div>
        <!-- /#sidebar-wrapper -->
        
        <!-- Page Content -->
        <div id="page-content-wrapper">
            <!-- Top Navigation -->
            <nav class="navbar navbar-expand-lg navbar-dark">
                <button class="btn" id="menu-toggle" aria-label="Toggle menu">
                    <i class="fa fa-bars neon-blue"></i>
                </button>
                
                <!-- System Messages -->
                <div class="center mx-auto" id="pageMessages"></div>
                
                <!-- Logout Button -->
                <a href="logout.php" class="btn btn-danger ml-auto">
                    <i class="fa fa-sign-out"></i>&nbsp; Logout
                </a>
            </nav>
            
            <!-- Main Content -->
            <div class="container-fluid">